// (c) 1999 - 2025 OneSpan North America Inc. All rights reserved.


/////////////////////////////////////////////////////////////////////////////
//
//
// This file is example source code. It is provided for your information and
// assistance. See your licence agreement for details and the terms and
// conditions of the licence which governs the use of the source code. By using
// such source code you will be accepting these terms and conditions. If you do
// not wish to accept these terms and conditions, DO NOT OPEN THE FILE OR USE
// THE SOURCE CODE.
//
// Note that there is NO WARRANTY.
//
//////////////////////////////////////////////////////////////////////////////


import UIKit

enum SharedPreferenceStorage {
    private static let prefActivatedUser               = "activatedUser"
    private static let prefLastRetrievedNotificationId = "lastRetrievedNotificationId"
    private static let prefNotificationId              = "notificationId"
    
    static func clean() {
        UserDefaults.standard.removeObject(forKey: prefActivatedUser)
        UserDefaults.standard.removeObject(forKey: prefNotificationId)
        UserDefaults.standard.removeObject(forKey: prefLastRetrievedNotificationId)
        UserDefaults.standard.synchronize()
    }
    
    // MARK: User management
    static func getActivatedUser() -> String? {
        return UserDefaults.standard.string(forKey: prefActivatedUser)
    }
    
    static func storeActivatedUser(activatedUser: String?) {
        UserDefaults.standard.set(activatedUser, forKey: prefActivatedUser)
        UserDefaults.standard.synchronize()
    }
    
    // MARK: Notification management
    static func storedNotificationId(user: String) -> String? {
        guard let notificationIds = UserDefaults.standard.dictionary(forKey: prefNotificationId) as? [String: String] else { return nil }
        return notificationIds.keys.contains(user) ? notificationIds[user] : nil
    }
        
    static func storeNotificationId(notificationID: String, user: String) {
        var notificationIDs = getNotificationIds()
        notificationIDs[user] = notificationID
        
        UserDefaults.standard.set(notificationIDs, forKey: prefNotificationId)
        UserDefaults.standard.synchronize()
    }
    
    static func removeNotificationId(user: String) {
        var notificationIDs = getNotificationIds()
        notificationIDs.removeValue(forKey: user)
        
        UserDefaults.standard.set(notificationIDs, forKey: prefNotificationId)
        UserDefaults.standard.synchronize()
    }
    
    static func getLastRetrievedStoredNotificationId() -> String? {
        return UserDefaults.standard.string(forKey: prefLastRetrievedNotificationId)
    }
    
    static func storeLastRetrievedNotificationId(_ notificationId: String) {
        UserDefaults.standard.set(notificationId, forKey: prefLastRetrievedNotificationId)
        UserDefaults.standard.synchronize()
    }
    
    private static func getNotificationIds() -> [String: String] {
        return UserDefaults.standard.dictionary(forKey: prefNotificationId) as? [String: String] ?? [:]
    }
}
